﻿using Foolproof;
using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Web;

namespace NVCC.WebUI.Models
{
    public class RoiSearhViewModel
    {
        [Display(Name = "First Name")]
        public string FirstName { get; set; }

        [Required(ErrorMessage = "At least the first character of the Last Name is required.")]
        [MinLength(1)]
        [Display(Name = "Last Name")]
        public string LastName { get; set; }

        [Required(ErrorMessage ="The last four digits of the patient's SSN are required")]
        [StringLength(4, MinimumLength = 4)]
        [MaxLength(4)]
        [MinLength(4)]
        [RegularExpression("^([0-9]{4})$", ErrorMessage = "The last four digits of the SSN must be exactly 4 digits.")]
        [Display(Name = "SSN last four digits")]
        public string LastFourOfSsn { get; set; }

        [StringLength(3, MinimumLength = 3)]
        [MaxLength(3)]
        [MinLength(3)]
        [RegularExpression("^([0-9]{3})$", ErrorMessage = "The first three digits of the SSN must be exactly 3 digits or be left blank.")]
        [Display(Name = "SSN first three digits")]
        [RequiredIfNotEmpty("MiddleTwoOfSsn", ErrorMessage = "You must enter either the whole SSN or only the last four digits.")]
        public string FirstThreeOfSsn { get; set; }

        [StringLength(2, MinimumLength = 2)]
        [MaxLength(2)]
        [MinLength(2)]
        [RegularExpression("^([0-9]{2})$", ErrorMessage = "The middle two digits of the SSN must be exactly 2 digits or be left blank.")]
        [Display(Name = "SSN Middle two digits")]
        [RequiredIfNotEmpty("FirstThreeOfSsn", ErrorMessage = "You must enter either the whole SSN or only the last four digits.")]
        public string MiddleTwoOfSsn { get; set; }

        [Display(Name = "Start Date (MM/DD/YYYY)")]
        [DisplayFormat(ApplyFormatInEditMode = true, DataFormatString = "{0:M/d/yyyy}")]
        [DataType(DataType.Date, ErrorMessage = "Start Date must be in MM/DD/YYYY format.")]
        public DateTime? StartDate { get; set; }

        [Display(Name = "End Date (MM/DD/YYYY)")]
        [DisplayFormat(ApplyFormatInEditMode = true, DataFormatString = "{0:M/d/yyyy}")]
        [DataType(DataType.Date, ErrorMessage = "End Date must be in MM/DD/YYYY format.")]
        public DateTime? EndDate { get; set; }

        public IEnumerable<RoiSearchResult> SearchResults { get; set; }

        public string FirstFiveOfSsn
        {
            get
            {
                if (!string.IsNullOrWhiteSpace(FirstThreeOfSsn) && FirstThreeOfSsn.Length == 3 && !string.IsNullOrWhiteSpace(MiddleTwoOfSsn) && MiddleTwoOfSsn.Length == 2)
                {
                    return FirstThreeOfSsn + MiddleTwoOfSsn;
                }
                return null;
            }
        }

        [Display(Name = "Patient SSN")]
        public string SSN
        {
            get
            {
                if (!string.IsNullOrWhiteSpace(FirstThreeOfSsn) && FirstThreeOfSsn.Length == 3 
                    && !string.IsNullOrWhiteSpace(MiddleTwoOfSsn) && MiddleTwoOfSsn.Length == 2
                    && !string.IsNullOrWhiteSpace(LastFourOfSsn) && LastFourOfSsn.Length == 4)
                {
                    return FirstThreeOfSsn + MiddleTwoOfSsn + LastFourOfSsn;
                }
                return null;
            }
        }
    }
}